/*
 *
 * Tworzenie okien potomnych
 *
 */
#include <windows.h>
#include <string.h>

/* Deklaracja wyprzedzajca: funkcja obsugi okna */
LRESULT CALLBACK WindowProcedure(HWND, UINT, WPARAM, LPARAM);
/* Nazwa klasy okna */
char szClassName[] = "PRZYKLAD";

struct
{
     TCHAR * szClass;
     int     iStyle ;
     TCHAR * szText ;
} child[] =
{
     "BUTTON"  , BS_PUSHBUTTON    ,  "PUSHBUTTON",
     "BUTTON"  , BS_AUTOCHECKBOX  ,  "CHECKBOX",
     "BUTTON"  , BS_RADIOBUTTON   ,  "RADIOBUTTON",
     "BUTTON"  , BS_GROUPBOX      ,  "GROUPBOX",
     "EDIT"    , WS_BORDER        ,  "TEXTBOX",
     "STATIC"  , WS_BORDER        ,  "STATIC",
} ;

#define NUM (sizeof child / sizeof child[0])

int WINAPI WinMain(HINSTANCE hThisInstance, HINSTANCE hPrevInstance, 
                   LPSTR lpszArgument, int nFunsterStil)
{
    HWND hwnd;               /* Uchwyt okna */
    MSG messages;            /* Komunikaty okna */
    WNDCLASSEX wincl;        /* Struktura klasy okna */

    /* Klasa okna */
    wincl.hInstance     = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc   = WindowProcedure;    // wskanik na funkcj 
                                              // obsugi okna  
    wincl.style         = CS_DBLCLKS;                 
    wincl.cbSize        = sizeof(WNDCLASSEX);

    /* Domylna ikona i wskanik myszy */
    wincl.hIcon   = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor(NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL; 
    wincl.cbClsExtra = 0;   
    wincl.cbWndExtra = 0;   
    /* Jasnoszare to */
    wincl.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);

    /* Rejestruj klas okna */
    if(!RegisterClassEx(&wincl)) return 0;

    /* Twrz okno */
    hwnd = CreateWindowEx(
           0,                   
           szClassName,         
           "PRZYKLAD",       
           WS_OVERLAPPEDWINDOW, 
           CW_USEDEFAULT, CW_USEDEFAULT,       
           CW_USEDEFAULT, CW_USEDEFAULT,       
           HWND_DESKTOP,        
           NULL,                
           hThisInstance,       
           NULL                 
           );

    ShowWindow(hwnd, nFunsterStil);
    /* Ptla obsugi komunikatw */
    while(GetMessage(&messages, NULL, 0, 0))
    {
           /* Tumacz kody rozszerzone */
           TranslateMessage(&messages);
           /* Obsu komunikat */
           DispatchMessage(&messages);
    }

    /* Zwr parametr podany w PostQuitMessage( ) */
    return messages.wParam;
}


/* T funkcj woa DispatchMessage( ) */
LRESULT CALLBACK WindowProcedure(HWND hwnd, UINT message, 
                                 WPARAM wParam, LPARAM lParam)
{
    static HWND hwndChild[NUM];
    static int  cxChar, cyChar;  
    int         i;
    
    switch (message)                  
    {
           case WM_CREATE :
                cxChar = LOWORD (GetDialogBaseUnits ()) ;
                cyChar = HIWORD (GetDialogBaseUnits ()) ;
                          
                for (i = 0 ; i < NUM ; i++)
                    hwndChild[i] = CreateWindow ( child[i].szClass, 
                                   child[i].szText,
                                   WS_CHILD | WS_VISIBLE | 
                                   child[i].iStyle,
                                   cxChar, cyChar * (1 + 3 * i),
                                   20 * cxChar, 2 * cyChar,
                                   hwnd, (HMENU) i,
                                   ((LPCREATESTRUCT) lParam)->hInstance, 
                                   NULL) ; 
                                   
              break;

           case WM_DESTROY:
              PostQuitMessage(0);        
              break;
              
           default:                   
              return DefWindowProc(hwnd, message, wParam, lParam);
    }
    return 0;
}
